# Prof-TC
# Decembre 2020
# Lentille convergente

print("_________________________________________________________")
print("Lentille convergente")
print("_________________________________________________________")

# Importation des bibliotheques
from matplotlib import pyplot as plt

# Donneees du probleme
f=float(input("Introduire la distance focale f de la lentille convergente en cm (f<50cm): f = "))
xo=-float(input("Introduire la distance OA entre le centre optique de la lentille et l'objet en cm (OA<100cm): OA = "))
yo=float(input("Introduire la taille AB de l'objet en cm 'AB<10cm): AB = "))


# Calculs préléminaires
xi=xo*f/(xo+f) # Calcul de la distance OA"entre le centre optique O et l'image
g=xi/xo # Calcul du grandissement
yi=g*yo # Calcul de la taille de l'image
longueur = xi # Longueur des rayons

fig, ax = plt.subplots()  # Initialisation de la figure

# Différents paramètres
couleurs = ['green', 'tomato', 'purple'] # Couleur des trois rayons
labels = ["Rayon parallèle à l'axe optique", "Rayon passant par le centre optique O", "Rayon passant par le foyer objet F"] # Noms des différents rayons
liste = [yo, 0, f/(xo+f)*yo]

# Calculs des tracé des différents rayons
for i, h in enumerate(liste):
    alpha = (yo-h)/xo # Angle d'inclinaison du rayon en amont de la lentille
    beta = alpha - h/f # Angle d'inclinaison du rayon en aval de la lentille
    x = [xo, 0, 0 + longueur] # Abscisse de la longueur du rayon
    y = [yo, h, h + longueur*beta] # Ordonnée de la longueur du rayon
    plt.plot(x, y, linewidth=1, c=couleurs[i], label=labels[i]) # Tracé du rayon

# Tracés des différentes parties du graphique
plt.arrow(0, 0, 0,  10, head_width=4, head_length=0.8, lw=2, color='black') # lentille
plt.arrow(0, 0, 0, -10, head_width=4, head_length=0.8, lw=2, color='black') # lentille
plt.arrow(xo, 0, 0,  yo-0.8, head_width=2, head_length=0.8, lw=2, color="blue") # Objet
plt.arrow(xi, 0, 0,  g*yo+0.8, head_width=2, head_length=0.8, lw=2, color="blue") # Image
plt.scatter([-f, f], [0, 0], s=100, color='red') # Représentation des foyers
plt.scatter(0, 0, s=100, color='black') # Représentation du centre optique
plt.plot([-100,100],[0, 0], lw=1, ls='dashed', c='black') # axe optique
plt.legend(loc="lower left") # Légende dans le coin inférieur gauche
plt.ylim(-12, 12) #Valeurs limites vertivale du graphique
plt.text(-f-1, -1.2, "F", color="red", fontsize=14) # Affichage du foyer objet F
plt.text(f+0.5, 0.8, "F'", color="red", fontsize=14) # Affichage du oyer image F'
plt.text(0.5, 0.4, "O", color = "black", fontsize=14) # Affichage du centre optique O
plt.text(xo-1, -0.8, "A", color = "blue", fontsize=14) # Affichage du point objet A
plt.text(xo-1, yo+0.2, "B", color = "blue", fontsize=14) # Affichage du point objet B
plt.text(xi-0.2, 0.2, "A'", color = "blue", fontsize=14) # Affichage du point image A'
plt.text(xi-0.2, yi-0.8, "B'", color = "blue", fontsize=14) # Affichage du point image B'

# Calcul des arrondis pour l'affichage des différentes valeurs
f=round(f,1) # Valeur de la distance focale f en cm avec 1 decimale
xo=round(xo,1) # Valeur de la distance objet OA en cm avec 1 decimale
yo=round(yo,1) # Valeur de la taille AB de l'objet en cm avec 1 decimale
xi=round(xi,1) # Valeur de la distance image oA' en cm avec 1 decimale
yi=round(yi,1) # Valeur de la taille A'B' de l'image en cm avec 1 decimale
g=round(g,1) # Valeur du grandissement avec 1 decimale

# Affichage des différentes valeurs
plt.text(-25, 11, "Prof-TC - Lentille convergente", color='green', fontsize=14) # Affichage du titre dans le graphique
plt.text(60, 11, "f = "+str(f)+" cm", color='green', fontsize=14) # Affichage de la valeur de lz distance focale f dans le graphique
plt.text(60, 10, "OA = "+str(xo)+" cm", color='green', fontsize=14) # Affichage de la valeur de n2 dans le graphique
plt.text(60, 9, "AB = "+str(yo)+" cm", color='green', fontsize=14) # Affichage de la valeur de i1 dans le graphique
plt.text(60, 8, "OA' = "+str(xi)+" cm", color='blue', fontsize=14) # Affichage de la valeur de i2 dans le graphique
plt.text(60, 7, "A'B' = "+str(yi)+" cm", color='blue', fontsize=14) # Affichage de la valeur de i2 dans le graphique
plt.text(60, 6, "grandissement = "+str(g), color='blue', fontsize=14) # Affichage de la valeur de i2 dans le graphique


fig.savefig("Lentille convergente") # Sauvegarde de la figure dans le dossier où se trouve le programme

plt.show() # Affichage de la figure